# -*- coding: utf-8 -*-
import glob
import libhro
import os
import ConfigParser
import time
import subprocess

def how_long(filename):#OGGファイルの長さを調べる
	output = subprocess.check_output(["sox", "--info", "-d", filename])
	#print output
	minute = output[4]
	ten_second = output[6]
	second = output[7]
	file_info = (minute , ten_second, second)
	return(file_info)

conf = ConfigParser.SafeConfigParser()
conf.read("./sr.conf")
echo_threshold = int(conf.get("analyze", "echo_threshold"))
unite_echo_threshold = int(conf.get("analyze", "unite_echo_threshold"))
compared_with_pixels = conf.get("analyze", "compared_with_pixels")
get_pixel = conf.get("analyze", "get_pixel")


filelist = glob.glob("./*/*.ogg")

for cnt in (filelist):
	print cnt[6:][:10]
	if os.path.exists("./CSV/" + cnt[6:][:10] + ".csv") == True:
		libhro.make_csv("a", cnt[6:][:10], echo_threshold, unite_echo_threshold, compared_with_pixels, get_pixel)
	elif os.path.exists("./monoPNG/" + cnt[6:][:10] + ".png") == True:
		libhro.make_csv("ac", cnt[6:][:10], echo_threshold, unite_echo_threshold, compared_with_pixels, get_pixel)
	else:
		if how_long("./ogg/"+ cnt[6:][:10] + ".ogg")[0] == "5":
			libhro.spec(cnt[6:][:10], True)
			time.sleep(5)
			libhro.make_csv("ac", cnt[6:][:10], echo_threshold, unite_echo_threshold, compared_with_pixels, get_pixel)
